<?php

function __RB_api($target, $data, &$json, $displayOutput = false)
{
    $data['SERVER_NAME'] = $_SERVER['SERVER_NAME'];

    $data_string = json_encode($data);
    
    $api = curl_init();
    
    $options = [
        CURLOPT_URL => __RB_API_URL . $target,
        CURLOPT_PORT => "443",
        CURLOPT_USERPWD => __RB_API_AUTH_USERNAME . ":" . __RB_API_AUTH_PASSWORD,
        CURLOPT_HTTPHEADER => ['Content-Type:application/json', 'Content-Length: ' . strlen($data_string)],
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => $data_string,
        CURLOPT_HEADER => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 90,
    ];

    curl_setopt_array($api, $options);

    $content = curl_exec($api);

    if ($displayOutput) {
        var_dump($content);
        var_dump(__RB_API_URL . $target);
        exit;
    }

    $content = explode("\r\n\r\n", $content);
    $json = json_decode(end($content), true);
    $httpCode = curl_getinfo($api, CURLINFO_HTTP_CODE);

    curl_close($api);

    return $httpCode == __RB_API_ACCEPT_201 || $httpCode == __RB_API_ACCEPT_202;
}
