<?php

require_once __DIR__ . '/../init_cloud.php';

$response = [
    'data'   => [],
    'status' => 'failed'
];

http_response_code(422);

$inputRules = [
    "company_name" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "contact_person" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "contact_email" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "contact_phone" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "note" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
    "status" => ["required" => true, "validate" => ["filter" => FILTER_SANITIZE_FULL_SPECIAL_CHARS]],
];

$failed = false;

$error = [];

function validateIntPos($id)
{
    return !(empty($id) || !is_numeric($id) || $id < 1);
}

if (__RB_validateInput($inputRules, 'set_meeting_customer', $error)) {
    $objCreate = [];

    foreach ($inputRules as $key => $val) {
        if ($key == 'id') {
            continue;
        }

        $objCreate[$key] = $_POST[$key];
    }

    $data = [
        'id' => $_POST['id'],
        'id_customer' => $_SESSION['id'],
        'data' => $objCreate
    ];

    __RB_api_cloud('setMeetingCustomer', $data, $json);

    http_response_code(200);

    $response = ["status" => 'success'];

    echo json_encode($response);

    exit;
} else {
    $response = [
        'status' => 'failed',
        'errors' => $error
    ];

    echo json_encode($response);

    exit;
}
